/*
 * Decompiled with CFR 0.152.
 */
package net.impactdev.impactor.relocations.nonapi.io.github.classgraph.classloaderhandler;

import java.net.URL;
import java.net.URLClassLoader;
import net.impactdev.impactor.relocations.nonapi.io.github.classgraph.classloaderhandler.ClassLoaderHandler;
import net.impactdev.impactor.relocations.nonapi.io.github.classgraph.classpath.ClassLoaderOrder;
import net.impactdev.impactor.relocations.nonapi.io.github.classgraph.classpath.ClasspathOrder;
import net.impactdev.impactor.relocations.nonapi.io.github.classgraph.scanspec.ScanSpec;
import net.impactdev.impactor.relocations.nonapi.io.github.classgraph.utils.LogNode;

class URLClassLoaderHandler
implements ClassLoaderHandler {
    private URLClassLoaderHandler() {
    }

    public static boolean canHandle(Class<?> classLoaderClass, LogNode log) {
        return "java.net.URLClassLoader".equals(classLoaderClass.getName());
    }

    public static void findClassLoaderOrder(ClassLoader classLoader, ClassLoaderOrder classLoaderOrder, LogNode log) {
        classLoaderOrder.delegateTo(classLoader.getParent(), true, log);
        classLoaderOrder.add(classLoader, log);
    }

    public static void findClasspathOrder(ClassLoader classLoader, ClasspathOrder classpathOrder, ScanSpec scanSpec, LogNode log) {
        URL[] urls2 = ((URLClassLoader)classLoader).getURLs();
        if (urls2 != null) {
            for (URL url : urls2) {
                if (url == null) continue;
                classpathOrder.addClasspathEntry((Object)url, classLoader, scanSpec, log);
            }
        }
    }
}

